<?php

ini_set('display_errors', 1);
ini_set('error_reporting', E_ALL);

// フォームのボタンが押されたら
if ($_SERVER["REQUEST_METHOD"] == "POST") {
		// フォームから送信されたデータを各変数に格納
		$companyname = $_POST["companyname"];
		$departmentname = $_POST["departmentname"];
		$email = $_POST["email"];
		$tel = $_POST["tel"];
		$content  = $_POST["content"];
}

// 送信ボタンが押されたら
if (isset($_POST["submit"])) {
		// 送信ボタンが押された時に動作する処理をここに記述する

		// 日本語をメールで送る場合のおまじない
		mb_language("ja");
		mb_internal_encoding("UTF-8");

		//mb_send_mail("kanda.it.school.trial@gmail.com", "メール送信テスト", "メール本文");

		// サンキューメール（お客様）
		// 件名を変数subjectに格納
		$subject = "［自動送信］お問い合わせ内容の確認";

		// メール本文を変数bodyに格納

		$body = <<< EOM

{$companyname} 様


この度はお問い合わせいただきありがとうございました。
弊社スタッフが折り返しご連絡させていただきます。

※ご確認メールが3営業日経過しても届かない場合は、恐れ入りますが、再度お問い合わせください。
※返信にお時間を頂く場合がございます。予めご了承ください。


===================================================


お問い合わせ内容


【 社名 】
{$companyname}

【 ご担当部署名 】
{$departmentname}

【 メールアドレス 】
{$email}

【 電話番号 】
{$tel}

【 お問い合わせ内容 】
{$content}


===================================================

内容を確認のうえ、回答させて頂きます。
しばらくお待ちください。




EOM;

		// 送信元のメールアドレスを変数fromEmailに格納
		$fromEmail = "info@gifu-rinei.jp";

		// 送信元の名前を変数fromNameに格納
		$fromName = "リンエイ株式会社";

		// ヘッダ情報を変数headerに格納する
		$header = "From: " .mb_encode_mimeheader($fromName) ."<{$fromEmail}>";

		// お客様へメール送信を行う
		mb_send_mail($email, $subject, $body, $header);


		// サンキューメール（管理者）
		// 管理者のメールアドレス
		$email_admin = "info@gifu-rinei.jp";
		// 件名を変数subjectに格納
		$subject_admin = "ウェブサイトよりお問い合わせがありました。";

		// メール本文を変数bodyに格納
		$body_admin = <<< EOM


ウェブサイトより下記内容でお問い合わせがありました。


===================================================


【 社名 】
{$companyname}

【 ご担当部署名 】
{$departmentname}

【 メールアドレス 】
{$email}

【 電話番号 】
{$tel}

【 お問い合わせ内容 】
{$content}


===================================================


EOM;

		// 送信元の名前を変数fromNameに格納
		$fromName = "{$companyname}";

		// ヘッダ情報を変数headerに格納する
		$header = "From: " .mb_encode_mimeheader($fromName) ."<{$fromEmail}>";

		// 管理者へメール送信を行う
		mb_send_mail($email_admin, $subject_admin, $body_admin, $header);


		// サンクスページに画面遷移させる
		header("Location: https://www.rinei-web.co.jp/contact/thanks.php");
		exit;
	}
?>
<html lang="ja">
<head>
<meta charset="UTF-8">
<title>入力内容の確認｜自転車関連部品供給・開発・製造　-　リンエイ株式会社</title>
<meta name="description" content="リンエイ株式会社に興味を持っていただきき誠にありがとうございます。お見積り、ご依頼、ご質問など、お気軽にお問い合わせください。 担当者より折り返しご連絡させていただきます。">
<meta property="og:type" content="website">
<meta property="og:title" content="入力内容の確認｜自転車関連部品供給・開発・製造　-　リンエイ株式会社">
<meta property="og:description" content="リンエイ株式会社に興味を持っていただきき誠にありがとうございます。お見積り、ご依頼、ご質問など、お気軽にお問い合わせください。 担当者より折り返しご連絡させていただきます。">
<meta property="og:url" content="https://www.rinei-web.co.jp">
<meta property="og:site_name" content="入力内容の確認｜自転車関連部品供給・開発・製造　-　リンエイ株式会社">
<meta property="og:image" content="../img/rinei-ogp.png">
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="入力内容の確認｜自転車関連部品供給・開発・製造　-　リンエイ株式会社">
<meta name="twitter:description" content="リンエイ株式会社に興味を持っていただきき誠にありがとうございます。お見積り、ご依頼、ご質問など、お気軽にお問い合わせください。 担当者より折り返しご連絡させていただきます。">
<link rel="canonical" href="https://www.rinei-web.co.jp">
<link rel="stylesheet" href="../css/base.css" type="text/css">
<link rel="stylesheet" href="../css/contents.css" type="text/css">
<link rel="stylesheet" href="https://use.typekit.net/gsz3mqa.css">
<link rel="icon" href="../favicon.ico">
<link rel="apple-touch-icon" sizes="180x180" href="../favicon.ico">
<meta name="viewport" content="width=device-width,initial-scale=1">
</head>
<body>
	<div class="start"></div>
	<header class="header header_naka">
		<h1 class="header__logo"><a href="../index.html">RINEI</a></h1>
		<div class="navigation__wrap">
			<nav class="header__navi">
				<ul>
          <li><a href="../index.html">TOP</a></li>
					<li><a href="../news/">NEWS</a></li>
					<li><a href="../aboutus/">ABOUT US</a></li>
					<li><a href="../business/">BUSINESS</a></li>
					<li><a href="../company/">COMPANY</a></li>
					<li><a href="../recruiting/">RECRUITING</a></li>
					<li><a href="../contact/">CONTACT</a></li>
				</ul>
			</nav>
			<div class="header__siteCategory"><a href="https://www.rinei-web.jp/" target="_blank">B to B STORE</a></div>
			<div class="toggleNavi">
				<div class="toggleNavi__icon"><img src="../img/togglenavi.svg" alt=""><span><img src="../img/togglenavi-hover.svg" alt=""></span></div>
				<div class="toggleNavi__wrap">
          <div class="toggleNavi__menu">
						<div class="toggleNavi__logo"><a href="../index.html">RINEI</a></div>
						<div class="toggleNavi__contents">
              <nav class="toggleNavi__list">
    						<ul>
    							<li><a href="../index.html"><span>TOP</span><span>トップ</span></a></li>
    							<li><a href="../news/"><span>NEWS</span><span>ニュース</span></a></li>
    							<li><a href="../aboutus/"><span>ABOUT US</span><span>リンエイのシゴト</span></a></li>
    							<li><a href="../business/"><span>BUSINESS</span><span>事業内容</span></a></li>
    							<li><a href="../company/"><span>COMPANY</span><span>企業情報</span></a></li>
    							<li><a href="../recruiting/"><span>RECRUITING</span><span>採用情報</span></a></li>
    							<li><a href="../contact/"><span>CONTACT</span><span>お問い合わせ</span></a></li>
    						</ul>
    					</nav>
              <div class="toggleNavi__contents__info">
                <div class="toggleNavi__contents__info__group">
                  <div class="toggleNavi__siteCategory"><a href="https://www.rinei-web.jp/" target="_blank">B to B STORE</a></div>
									<ul class="toggleNavi__info__list">
										<li><a href="../video_production/">VIDEO PRODUCTION</a></li>
										<li><a href="../privacy/">プライバシーポリシー</a></li>
									</ul>
                </div>
                <div class="toggleNavi__contents__info__group">
                  <ul class="toggleNavi__sns">
        						<li><a href="https://www.instagram.com/rinei_gifu/" target="_blank"><img src="../img/icon-instagram-g.svg" alt="instagram"></a></li>
        						<li><a href="https://www.facebook.com/%E3%83%AA%E3%83%B3%E3%82%A8%E3%82%A4%E6%A0%AA%E5%BC%8F%E4%BC%9A%E7%A4%BE-1158818940824190/" target="_blank"><img src="../img/icon-facebook-g.svg" alt="facebook"></a></li>
        					</ul>
                  <div class="toggleNavi__copy only_pc">&copy; RINEI ALL RIGHTS RESERVED.</div>
                </div>
              </div>
            </div>
					</div>
          <div class="toggleNavi__eyecatch">RINEI</div>
				</div>
			</div>
		</div>
	</header>
	<main id="main">
    <section class="contact__section">
			<h2 class="contact__section__title"><span>CONTACT</span>入力内容の確認</h2>
			<div class="contact__section__message">入力内容をご確認いただき、問題がないようでしたら「送信」ボタンを選択してください。</div>
			<div>
				<form action="confirm.php" method="post">
					<input type="hidden" name="companyname" value="<?php echo $companyname; ?>">
					<input type="hidden" name="departmentname" value="<?php echo $departmentname; ?>">
					<input type="hidden" name="email" value="<?php echo $email; ?>">
					<input type="hidden" name="tel" value="<?php echo $tel; ?>">
					<input type="hidden" name="content" value="<?php echo $content; ?>">
					<div class="contact__form">
						<ul class="contact__form__list">
							<li>
								<div class="contact__form__list-title">社名</div>
								<div class="contact__form__list-contents"><?php echo $companyname; ?></div>
							</li>
							<li>
								<div class="contact__form__list-title">ご担当部署名</div>
								<div class="contact__form__list-contents"><?php echo $departmentname; ?></div>
							</li>
							<li>
								<div class="contact__form__list-title">メールアドレス</div>
								<div class="contact__form__list-contents"><?php echo $email; ?></div>
							</li>
							<li>
								<div class="contact__form__list-title">電話番号</div>
								<div class="contact__form__list-contents"><?php echo $tel; ?></div>
							</li>
							<li>
								<div class="contact__form__list-title">お問い合わせ内容</div>
								<div class="contact__form__list-contents"><?php echo nl2br($content); ?></div>
							</li>
						</ul>
						<div class="confirm__fix"><input type="button" value="入力内容を修正する" onclick="history.back(-1)"></div>
						<div class="send_btn"><button type="submit" name="submit">送信</button></div>
					</div>
				</form>
			</div>
    </section>
	</main>
	<footer class="footer">
		<div class="footer__wrap">
			<div class="footer__contents">
				<div class="footer__company">
					<div class="footer__company-logo"><a href="../index.html">RINEI</a></div>
					<ul class="footer__company-sns">
						<li><a href="https://www.instagram.com/rinei_gifu/" target="_blank"><img src="../img/icon-instagram-lg.svg" alt="instagram"></a></li>
						<li><a href="https://www.facebook.com/%E3%83%AA%E3%83%B3%E3%82%A8%E3%82%A4%E6%A0%AA%E5%BC%8F%E4%BC%9A%E7%A4%BE-1158818940824190/" target="_blank"><img src="../img/icon-facebook-lg.svg" alt="facebook"></a></li>
					</ul>
				</div>
				<div class="footer__navigation">
					<ul>
						<li><a href="../index.html">TOP</a></li>
						<li><a href="../news/">NEWS</a></li>
						<li><a href="../aboutus/">ABOUT US</a></li>
						<li><a href="../business/">BUSINESS</a></li>
					</ul>
					<ul>
						<li><a href="../company/">COMPANY</a></li>
						<li><a href="../recruiting/">RECRUITING</a></li>
						<li><a href="../contact/">CONTACT</a></li>
					</ul>
				</div>
			</div>
			<div class="footer__info">
				<div class="footer__info-siteCategory"><a href="https://www.rinei-web.jp/" target="_blank">B to B STORE</a></div>
        <div class="footer__info__detail">
					<div class="footer__info__detail-privacy"><a href="../privacy/">プライバシーポリシー</a></div>
					<div class="footer__info__detail-copy">&copy; RINEI ALL RIGHTS RESERVED.</div>
				</div>
			</div>
		</div>
	</footer>
	<script src="../js/jquery-1.12.3.min.js"></script>
	<script src="../js/contents.js" type="text/javascript"></script>
</body>
</html>
